; The last ever MSN Chat passport updater - 16/05/2017
; - Based on my previous work (sslupdatefix.mrc) - 10/04/2006
; - Update $sockerr check for AdiIRC compatibility - 14/01/2025

; - Why doesn't it get my PassportProfile? It's no longer sent by MSN.

;Just type /ppu.update to update passport
;You may need to change the %variables to suit your connection

alias PPU.Update {
  if (!$sslready) { PPU.Result NeedSSL | halt }
  if ($2) getinfo $1 $2
  else {
    if (!%Email) set %Email $$?"Please enter your email address"
    if (!%Passwd) set %Passwd $$?"Please enter your password"
    PPU.Getinfo %Email %Passwd
  }
  set %PPU.time $ticks
}

alias PPU.Result {
  if ($1 == Fail) echo -at [Update Status] Passport Update Failed. Please check your username and password
  elseif ($1 == GotTP) {
    if ($right($gettok($2,1,38), -2) != $null) {
      set %Ticket $ifmatch
    }
    if ($right($gettok($2,2,38), -2) != $null) {
      set %Profile $ifmatch
    }
    echo -at [Update Status] Complete ( $+ $iif(%Email,%Email,unknown) - $calc(($ticks - %PPU.time) / 1000) $+ s)
    unset %PPU.time
  }
  elseif ($1 == NeedSSL) {
    echo -at [Update Status] Passport Update Failed. SSL not available.
  }
  else echo -at [Update Status] Unknown. (An Error Has Occurred) $1-
}

on 1:SOCKOPEN:PPU.Update.*:{
  if (!$sockerr) {
    sockwrite -t $sockname GET /login2.srf HTTP/1.0 $+ $crlf $+ $&
      Authorization: Passport1.4 OrgVerb=GET,OrgURL=?,sign-in= $+ $PPU.URLEncode(%Email) $+ ,pwd= $+ $PPU.URLEncode(%Passwd) $+ ,id=507 $+ $crlf $+ $&
      Host: login.live.com $+ $crlf $+ $crlf
  }
}

on 1:sockread:PPU.Update.*:{
  var %x | sockread %x | tokenize 32 %x
  if ($1 isin authentication-info: www-authenticate:) {
    if ($gettok($3,1,44) == da-status=failed) PPU.Result Fail NoRetry
    elseif ($gettok($3,1,44) == da-status=success) PPU.Result GotTP $gettok($3,2,39)
  }
  elseif ($1 == Location:) { sockopen -e PPU.Update. $+ $r(1111,9999) $gettok($2-,2,47) 443 }
}

alias PPU.URLEncode {
  var %encode = $1-
  while ($regex($eval(%encode,1), /([^a-zA-Z0-9_\-\.])/)) {
    var %t = $regsub($eval(%encode,1), /([^a-zA-Z0-9_\-\.])/, $+(,$base($asc($regml(1)),10,16,2)), %encode)
  }
  return $replace(%encode, , %)
}

alias PPU.GetInfo {
  if ($2) { set %Email $1 | set %Passwd $2 }
  sockopen -e PPU.Update. $+ $r(1111,9999) login.live.com 443
}
